using System;

namespace HIPS.Web.Model.AssistedRegistration
{
    /// <summary>
    /// Represents an already validated IHI used to identify a healthcare recipient.
    /// </summary>
    /// TODO: Refactor remove
    public class VerifiedIhi
    {
        /// <summary>
        ///     The IHI that has been validated by an HI Provider.
        /// </summary>
        public string Ihi { get; private set; }

        /// <summary>
        ///     The IHI Status that has been validated by an HI Provider.
        /// </summary>
        public int IhiStatusId { get; private set; }

        /// <summary>
        ///     The IHI Record Status that has been validated by an HI Provider.
        /// </summary>
        public int IhiRecordStatusId { get; private set; }

        /// <summary>
        ///     The DateTime this record was last validated by an HI Provider.
        /// </summary>
        public DateTime DateLastValidated { get; private set; }

        public VerifiedIhi(string ihi, int ihiStatusId, int ihiRecordStatusId, DateTime dateLastValidated)
        {
            Ihi = ihi;
            IhiStatusId = ihiStatusId;
            IhiRecordStatusId = ihiRecordStatusId;
            DateLastValidated = dateLastValidated;
        }
    }
}
